#include	"led.h"

_LED_STRUCT_ led;

void	initLEDPort(void)
{
	led1_port = c_LED_OFF;
	led2_port = c_LED_OFF;
	led3_port = c_LED_OFF;
	led1_dir = 0;
	led2_dir = 0;
	led3_dir = 0;
}

void turnLED(u8 led_ptn, u8 on_off)
{
	if(on_off)
	{
		if(led_ptn & 0x01)
			led1_port = c_LED_ON;
		else
			led1_port = c_LED_OFF;
			
		if(led_ptn & 0x02)
			led2_port = c_LED_ON;
		else
			led2_port = c_LED_OFF;
			
		if(led_ptn & 0x04)
			led3_port = c_LED_ON;
		else
			led3_port = c_LED_OFF;	
	}
	else
	{
		led1_port = c_LED_OFF;
		led2_port = c_LED_OFF;
		led3_port = c_LED_OFF;
	}
}

void	initLEDPattern(u8 flag, u8 on_tm, u8 off_tm, u8 tms)
{
	led.flag.val = flag;
	led.on_time = on_tm;
	led.off_time = off_tm;
	led.on_off_times = tms;
	
	led.on_off_cnt = led.on_time;
	led.flag.bits.on_off = 0;
	led.flag.bits.en = 1;	

	turnLED(led.flag.val & 0x0F, !led.flag.bits.on_off);
}

// to update per 8ms
void	updateLED(void)
{
	if(led.flag.bits.en)
	{
		if(--led.on_off_cnt==0)
		{
			led.on_off_cnt = led.on_time;
			if(led.flag.bits.flsh)
			{
				if(led.flag.bits.on_off == 0)
				{
					led.flag.bits.on_off = 1;
					led.on_off_cnt = led.off_time;
				}	
				else
					led.flag.bits.on_off = 0;
			}
			if(led.on_off_times)
			{
				if(--led.on_off_times==0)
				{
					led.flag.bits.en = 0;
					led.flag.bits.on_off = 1;
				}
			}
			turnLED(led.flag.val & 0x0F, !led.flag.bits.on_off);
		}
	}		
}

bit	chkLEDSts(void)
{
	return	led.flag.bits.en;
}
	
